//================================================================================
// DanishHUDnSB mutator, detects gamestyle and replaces HUD & ScoreBoard
//================================================================================

class PaleridersHUD_SB extends Mutator config (PaleridersHUD_SB);

var config string sDMGameName, sTDMGameName, sCTFGameName, sDOMGameName, sLMSGameName;
var config bool bDMShowEFF, bTDMShowEFF, bCTFShowEFF, bDOMShowEFF, bLMSShowEFF;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	switch (Level.Game.Default.GameName)
		{
			case "Tournament DeathMatch":
			Level.Game.GameName = sDMGameName;
//			Level.Game.GameEndedMessage = "is victorious!";
			if ( bDMShowEFF )
				{
				Level.Game.HUDType = Class'PaleridersHUD_SB.DMHUD';
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.DMSBeff';
				}
			else
				{
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.DMSB';
				}
			break;
			case "Tournament Team Game":
			Level.Game.GameName = sTDMGameName;
//			Level.Game.GameEndedMessage = "are victorious!";
			if ( bTDMShowEFF )
				{
				Level.Game.HUDType = Class'PaleridersHUD_SB.TDMHUD';
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.TDMSBeff';
				}
			else
				{
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.TDMSB';
				}
			break;
			case "Capture the Flag":
			Level.Game.GameName = sCTFGameName;
//			Level.Game.GameEndedMessage = "are victorious!";
			if ( bCTFShowEFF )
				{
				Level.Game.HUDType = Class'PaleridersHUD_SB.CTFHUD';
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.TDMSBeff';
				}
			else
				{
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.TDMSB';
				}
			break;
			case "Domination":
			Level.Game.GameName = sDOMGameName;
//			Level.Game.GameEndedMessage = "are victorious!";
			if ( bDOMShowEFF )
				{
				Level.Game.HUDType = Class'PaleridersHUD_SB.DOMHUD';
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.TDMSBeff';
				}
			else
				{
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.TDMSB';
				}
			break;
			case "Last Man Standing":
			Level.Game.GameName = sLMSGameName;
//			Level.Game.GameEndedMessage = "are victorious!";
			if ( bLMSShowEFF )
				{
				Level.Game.HUDType = Class'PaleridersHUD_SB.DMHUD';
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.LMSSB';
				}
			else
				{
				Level.Game.ScoreBoardType = Class'PaleridersHUD_SB.LMSSB';
				}
			break;
			default:
			return;
		}
}
